package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{Port, IpAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNetworkInsightsPathRequest(
    sourceIp: Option[IpAddress] = None,
    destinationIp: Option[IpAddress] = None,
    source: String,
    destination: String,
    protocol: zio.aws.ec2.model.Protocol,
    destinationPort: Option[Port] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    clientToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest = {
    import CreateNetworkInsightsPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
      .builder()
      .optionallyWith(
        sourceIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.sourceIp)
      .optionallyWith(
        destinationIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.destinationIp)
      .source(source: java.lang.String)
      .destination(destination: java.lang.String)
      .protocol(protocol.unwrap)
      .optionallyWith(
        destinationPort.map(value => Port.unwrap(value): Integer)
      )(_.destinationPort)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .clientToken(clientToken: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkInsightsPathRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInsightsPathRequest.wrap(buildAwsValue())
}
object CreateNetworkInsightsPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInsightsPathRequest =
      zio.aws.ec2.model.CreateNetworkInsightsPathRequest(
        sourceIp.map(value => value),
        destinationIp.map(value => value),
        source,
        destination,
        protocol,
        destinationPort.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken
      )
    def sourceIp: Option[IpAddress]
    def destinationIp: Option[IpAddress]
    def source: String
    def destination: String
    def protocol: zio.aws.ec2.model.Protocol
    def destinationPort: Option[Port]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: String
    def getSourceIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("sourceIp", sourceIp)
    def getDestinationIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("destinationIp", destinationIp)
    def getSource: ZIO[Any, Nothing, String] = ZIO.succeed(source)
    def getDestination: ZIO[Any, Nothing, String] = ZIO.succeed(destination)
    def getProtocol: ZIO[Any, Nothing, zio.aws.ec2.model.Protocol] =
      ZIO.succeed(protocol)
    def getDestinationPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
  ) extends zio.aws.ec2.model.CreateNetworkInsightsPathRequest.ReadOnly {
    override val sourceIp: Option[IpAddress] = scala
      .Option(impl.sourceIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val destinationIp: Option[IpAddress] = scala
      .Option(impl.destinationIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val source: String = impl.source(): String
    override val destination: String = impl.destination(): String
    override val protocol: zio.aws.ec2.model.Protocol =
      zio.aws.ec2.model.Protocol.wrap(impl.protocol())
    override val destinationPort: Option[Port] = scala
      .Option(impl.destinationPort())
      .map(value => zio.aws.ec2.model.primitives.Port(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val clientToken: String = impl.clientToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest
  ): zio.aws.ec2.model.CreateNetworkInsightsPathRequest.ReadOnly = new Wrapper(
    impl
  )
}
