package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, SecurityGroupId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClientVpnEndpointRequest(
    clientCidrBlock: String,
    serverCertificateArn: String,
    authenticationOptions: Iterable[
      zio.aws.ec2.model.ClientVpnAuthenticationRequest
    ],
    connectionLogOptions: zio.aws.ec2.model.ConnectionLogOptions,
    dnsServers: Option[Iterable[String]] = None,
    transportProtocol: Option[zio.aws.ec2.model.TransportProtocol] = None,
    vpnPort: Option[Integer] = None,
    description: Option[String] = None,
    splitTunnel: Option[Boolean] = None,
    clientToken: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    vpcId: Option[VpcId] = None,
    selfServicePortal: Option[zio.aws.ec2.model.SelfServicePortal] = None,
    clientConnectOptions: Option[zio.aws.ec2.model.ClientConnectOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest = {
    import CreateClientVpnEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
      .builder()
      .clientCidrBlock(clientCidrBlock: java.lang.String)
      .serverCertificateArn(serverCertificateArn: java.lang.String)
      .authenticationOptions(authenticationOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .connectionLogOptions(connectionLogOptions.buildAwsValue())
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(transportProtocol.map(value => value.unwrap))(
        _.transportProtocol
      )
      .optionallyWith(
        vpnPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.vpnPort)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(splitTunnel.map(value => value: java.lang.Boolean))(
        _.splitTunnel
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(selfServicePortal.map(value => value.unwrap))(
        _.selfServicePortal
      )
      .optionallyWith(clientConnectOptions.map(value => value.buildAwsValue()))(
        _.clientConnectOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateClientVpnEndpointRequest.ReadOnly =
    zio.aws.ec2.model.CreateClientVpnEndpointRequest.wrap(buildAwsValue())
}
object CreateClientVpnEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateClientVpnEndpointRequest =
      zio.aws.ec2.model.CreateClientVpnEndpointRequest(
        clientCidrBlock,
        serverCertificateArn,
        authenticationOptions.map { item =>
          item.asEditable
        },
        connectionLogOptions.asEditable,
        dnsServers.map(value => value),
        transportProtocol.map(value => value),
        vpnPort.map(value => value),
        description.map(value => value),
        splitTunnel.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        selfServicePortal.map(value => value),
        clientConnectOptions.map(value => value.asEditable)
      )
    def clientCidrBlock: String
    def serverCertificateArn: String
    def authenticationOptions
        : List[zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly]
    def connectionLogOptions: zio.aws.ec2.model.ConnectionLogOptions.ReadOnly
    def dnsServers: Option[List[String]]
    def transportProtocol: Option[zio.aws.ec2.model.TransportProtocol]
    def vpnPort: Option[Integer]
    def description: Option[String]
    def splitTunnel: Option[Boolean]
    def clientToken: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def vpcId: Option[VpcId]
    def selfServicePortal: Option[zio.aws.ec2.model.SelfServicePortal]
    def clientConnectOptions
        : Option[zio.aws.ec2.model.ClientConnectOptions.ReadOnly]
    def getClientCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(clientCidrBlock)
    def getServerCertificateArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serverCertificateArn)
    def getAuthenticationOptions: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly
    ]] = ZIO.succeed(authenticationOptions)
    def getConnectionLogOptions
        : ZIO[Any, Nothing, zio.aws.ec2.model.ConnectionLogOptions.ReadOnly] =
      ZIO.succeed(connectionLogOptions)
    def getDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getTransportProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransportProtocol] =
      AwsError.unwrapOptionField("transportProtocol", transportProtocol)
    def getVpnPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpnPort", vpnPort)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSplitTunnel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("splitTunnel", splitTunnel)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSelfServicePortal
        : ZIO[Any, AwsError, zio.aws.ec2.model.SelfServicePortal] =
      AwsError.unwrapOptionField("selfServicePortal", selfServicePortal)
    def getClientConnectOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientConnectOptions.ReadOnly] =
      AwsError.unwrapOptionField("clientConnectOptions", clientConnectOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
  ) extends zio.aws.ec2.model.CreateClientVpnEndpointRequest.ReadOnly {
    override val clientCidrBlock: String = impl.clientCidrBlock(): String
    override val serverCertificateArn: String =
      impl.serverCertificateArn(): String
    override val authenticationOptions
        : List[zio.aws.ec2.model.ClientVpnAuthenticationRequest.ReadOnly] = impl
      .authenticationOptions()
      .asScala
      .map { item =>
        zio.aws.ec2.model.ClientVpnAuthenticationRequest.wrap(item)
      }
      .toList
    override val connectionLogOptions
        : zio.aws.ec2.model.ConnectionLogOptions.ReadOnly =
      zio.aws.ec2.model.ConnectionLogOptions.wrap(impl.connectionLogOptions())
    override val dnsServers: Option[List[String]] = scala
      .Option(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val transportProtocol
        : Option[zio.aws.ec2.model.TransportProtocol] = scala
      .Option(impl.transportProtocol())
      .map(value => zio.aws.ec2.model.TransportProtocol.wrap(value))
    override val vpnPort: Option[Integer] = scala
      .Option(impl.vpnPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val splitTunnel: Option[Boolean] =
      scala.Option(impl.splitTunnel()).map(value => value: Boolean)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val selfServicePortal
        : Option[zio.aws.ec2.model.SelfServicePortal] = scala
      .Option(impl.selfServicePortal())
      .map(value => zio.aws.ec2.model.SelfServicePortal.wrap(value))
    override val clientConnectOptions
        : Option[zio.aws.ec2.model.ClientConnectOptions.ReadOnly] = scala
      .Option(impl.clientConnectOptions())
      .map(value => zio.aws.ec2.model.ClientConnectOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest
  ): zio.aws.ec2.model.CreateClientVpnEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
