package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationFleetRequest(
    allocationStrategy: Option[String] = None,
    clientToken: Option[String] = None,
    instanceTypeSpecifications: Iterable[
      zio.aws.ec2.model.ReservationFleetInstanceSpecification
    ],
    tenancy: Option[zio.aws.ec2.model.FleetCapacityReservationTenancy] = None,
    totalTargetCapacity: Integer,
    endDate: Option[MillisecondDateTime] = None,
    instanceMatchCriteria: Option[
      zio.aws.ec2.model.FleetInstanceMatchCriteria
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest = {
    import CreateCapacityReservationFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
      .builder()
      .optionallyWith(allocationStrategy.map(value => value: java.lang.String))(
        _.allocationStrategy
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .instanceTypeSpecifications(instanceTypeSpecifications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .totalTargetCapacity(
        Integer.unwrap(totalTargetCapacity): java.lang.Integer
      )
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateCapacityReservationFleetRequest.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationFleetRequest
      .wrap(buildAwsValue())
}
object CreateCapacityReservationFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationFleetRequest =
      zio.aws.ec2.model.CreateCapacityReservationFleetRequest(
        allocationStrategy.map(value => value),
        clientToken.map(value => value),
        instanceTypeSpecifications.map { item =>
          item.asEditable
        },
        tenancy.map(value => value),
        totalTargetCapacity,
        endDate.map(value => value),
        instanceMatchCriteria.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allocationStrategy: Option[String]
    def clientToken: Option[String]
    def instanceTypeSpecifications
        : List[zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly]
    def tenancy: Option[zio.aws.ec2.model.FleetCapacityReservationTenancy]
    def totalTargetCapacity: Integer
    def endDate: Option[MillisecondDateTime]
    def instanceMatchCriteria
        : Option[zio.aws.ec2.model.FleetInstanceMatchCriteria]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getAllocationStrategy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceTypeSpecifications: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly
    ]] = ZIO.succeed(instanceTypeSpecifications)
    def getTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationTenancy
    ] = AwsError.unwrapOptionField("tenancy", tenancy)
    def getTotalTargetCapacity: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(totalTargetCapacity)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
  ) extends zio.aws.ec2.model.CreateCapacityReservationFleetRequest.ReadOnly {
    override val allocationStrategy: Option[String] =
      scala.Option(impl.allocationStrategy()).map(value => value: String)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val instanceTypeSpecifications: List[
      zio.aws.ec2.model.ReservationFleetInstanceSpecification.ReadOnly
    ] = impl
      .instanceTypeSpecifications()
      .asScala
      .map { item =>
        zio.aws.ec2.model.ReservationFleetInstanceSpecification.wrap(item)
      }
      .toList
    override val tenancy
        : Option[zio.aws.ec2.model.FleetCapacityReservationTenancy] = scala
      .Option(impl.tenancy())
      .map(value =>
        zio.aws.ec2.model.FleetCapacityReservationTenancy.wrap(value)
      )
    override val totalTargetCapacity: Integer =
      zio.aws.ec2.model.primitives.Integer(impl.totalTargetCapacity())
    override val endDate: Option[MillisecondDateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val instanceMatchCriteria
        : Option[zio.aws.ec2.model.FleetInstanceMatchCriteria] = scala
      .Option(impl.instanceMatchCriteria())
      .map(value => zio.aws.ec2.model.FleetInstanceMatchCriteria.wrap(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest
  ): zio.aws.ec2.model.CreateCapacityReservationFleetRequest.ReadOnly =
    new Wrapper(impl)
}
