package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BundleTask(
    bundleId: Option[String] = None,
    bundleTaskError: Option[zio.aws.ec2.model.BundleTaskError] = None,
    instanceId: Option[String] = None,
    progress: Option[String] = None,
    startTime: Option[DateTime] = None,
    state: Option[zio.aws.ec2.model.BundleTaskState] = None,
    storage: Option[zio.aws.ec2.model.Storage] = None,
    updateTime: Option[DateTime] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.BundleTask = {
    import BundleTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BundleTask
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(bundleTaskError.map(value => value.buildAwsValue()))(
        _.bundleTaskError
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .optionallyWith(updateTime.map(value => DateTime.unwrap(value): Instant))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BundleTask.ReadOnly =
    zio.aws.ec2.model.BundleTask.wrap(buildAwsValue())
}
object BundleTask {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.BundleTask] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BundleTask = zio.aws.ec2.model.BundleTask(
      bundleId.map(value => value),
      bundleTaskError.map(value => value.asEditable),
      instanceId.map(value => value),
      progress.map(value => value),
      startTime.map(value => value),
      state.map(value => value),
      storage.map(value => value.asEditable),
      updateTime.map(value => value)
    )
    def bundleId: Option[String]
    def bundleTaskError: Option[zio.aws.ec2.model.BundleTaskError.ReadOnly]
    def instanceId: Option[String]
    def progress: Option[String]
    def startTime: Option[DateTime]
    def state: Option[zio.aws.ec2.model.BundleTaskState]
    def storage: Option[zio.aws.ec2.model.Storage.ReadOnly]
    def updateTime: Option[DateTime]
    def getBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getBundleTaskError
        : ZIO[Any, AwsError, zio.aws.ec2.model.BundleTaskError.ReadOnly] =
      AwsError.unwrapOptionField("bundleTaskError", bundleTaskError)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.BundleTaskState] =
      AwsError.unwrapOptionField("state", state)
    def getStorage: ZIO[Any, AwsError, zio.aws.ec2.model.Storage.ReadOnly] =
      AwsError.unwrapOptionField("storage", storage)
    def getUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BundleTask
  ) extends zio.aws.ec2.model.BundleTask.ReadOnly {
    override val bundleId: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
    override val bundleTaskError
        : Option[zio.aws.ec2.model.BundleTaskError.ReadOnly] = scala
      .Option(impl.bundleTaskError())
      .map(value => zio.aws.ec2.model.BundleTaskError.wrap(value))
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Option[zio.aws.ec2.model.BundleTaskState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.BundleTaskState.wrap(value))
    override val storage: Option[zio.aws.ec2.model.Storage.ReadOnly] = scala
      .Option(impl.storage())
      .map(value => zio.aws.ec2.model.Storage.wrap(value))
    override val updateTime: Option[DateTime] = scala
      .Option(impl.updateTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BundleTask
  ): zio.aws.ec2.model.BundleTask.ReadOnly = new Wrapper(impl)
}
