package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AthenaIntegration(
    integrationResultS3DestinationArn: String,
    partitionLoadFrequency: zio.aws.ec2.model.PartitionLoadFrequency,
    partitionStartDate: Option[MillisecondDateTime] = None,
    partitionEndDate: Option[MillisecondDateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AthenaIntegration = {
    import AthenaIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AthenaIntegration
      .builder()
      .integrationResultS3DestinationArn(
        integrationResultS3DestinationArn: java.lang.String
      )
      .partitionLoadFrequency(partitionLoadFrequency.unwrap)
      .optionallyWith(
        partitionStartDate.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.partitionStartDate)
      .optionallyWith(
        partitionEndDate.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.partitionEndDate)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AthenaIntegration.ReadOnly =
    zio.aws.ec2.model.AthenaIntegration.wrap(buildAwsValue())
}
object AthenaIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AthenaIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AthenaIntegration =
      zio.aws.ec2.model.AthenaIntegration(
        integrationResultS3DestinationArn,
        partitionLoadFrequency,
        partitionStartDate.map(value => value),
        partitionEndDate.map(value => value)
      )
    def integrationResultS3DestinationArn: String
    def partitionLoadFrequency: zio.aws.ec2.model.PartitionLoadFrequency
    def partitionStartDate: Option[MillisecondDateTime]
    def partitionEndDate: Option[MillisecondDateTime]
    def getIntegrationResultS3DestinationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(integrationResultS3DestinationArn)
    def getPartitionLoadFrequency
        : ZIO[Any, Nothing, zio.aws.ec2.model.PartitionLoadFrequency] =
      ZIO.succeed(partitionLoadFrequency)
    def getPartitionStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("partitionStartDate", partitionStartDate)
    def getPartitionEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("partitionEndDate", partitionEndDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AthenaIntegration
  ) extends zio.aws.ec2.model.AthenaIntegration.ReadOnly {
    override val integrationResultS3DestinationArn: String =
      impl.integrationResultS3DestinationArn(): String
    override val partitionLoadFrequency
        : zio.aws.ec2.model.PartitionLoadFrequency =
      zio.aws.ec2.model.PartitionLoadFrequency
        .wrap(impl.partitionLoadFrequency())
    override val partitionStartDate: Option[MillisecondDateTime] = scala
      .Option(impl.partitionStartDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val partitionEndDate: Option[MillisecondDateTime] = scala
      .Option(impl.partitionEndDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AthenaIntegration
  ): zio.aws.ec2.model.AthenaIntegration.ReadOnly = new Wrapper(impl)
}
