package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpnGateway(
    availabilityZone: Option[String] = None,
    state: Option[zio.aws.ec2.model.VpnState] = None,
    `type`: Option[zio.aws.ec2.model.GatewayType] = None,
    vpcAttachments: Option[Iterable[zio.aws.ec2.model.VpcAttachment]] = None,
    vpnGatewayId: Option[String] = None,
    amazonSideAsn: Option[Long] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.VpnGateway = {
    import VpnGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnGateway
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        vpcAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcAttachments)
      .optionallyWith(vpnGatewayId.map(value => value: java.lang.String))(
        _.vpnGatewayId
      )
      .optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(
        _.amazonSideAsn
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnGateway.ReadOnly =
    zio.aws.ec2.model.VpnGateway.wrap(buildAwsValue())
}
object VpnGateway {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpnGateway] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnGateway = zio.aws.ec2.model.VpnGateway(
      availabilityZone.map(value => value),
      state.map(value => value),
      `type`.map(value => value),
      vpcAttachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpnGatewayId.map(value => value),
      amazonSideAsn.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def availabilityZone: Option[String]
    def state: Option[zio.aws.ec2.model.VpnState]
    def `type`: Option[zio.aws.ec2.model.GatewayType]
    def vpcAttachments: Option[List[zio.aws.ec2.model.VpcAttachment.ReadOnly]]
    def vpnGatewayId: Option[String]
    def amazonSideAsn: Option[Long]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpnState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.GatewayType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpcAttachments
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpcAttachment.ReadOnly]] =
      AwsError.unwrapOptionField("vpcAttachments", vpcAttachments)
    def getVpnGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getAmazonSideAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnGateway
  ) extends zio.aws.ec2.model.VpnGateway.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.VpnState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.VpnState.wrap(value))
    override val `type`: Option[zio.aws.ec2.model.GatewayType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.GatewayType.wrap(value))
    override val vpcAttachments
        : Option[List[zio.aws.ec2.model.VpcAttachment.ReadOnly]] = scala
      .Option(impl.vpcAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpcAttachment.wrap(item)
        }.toList
      )
    override val vpnGatewayId: Option[String] =
      scala.Option(impl.vpnGatewayId()).map(value => value: String)
    override val amazonSideAsn: Option[Long] =
      scala.Option(impl.amazonSideAsn()).map(value => value: Long)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnGateway
  ): zio.aws.ec2.model.VpnGateway.ReadOnly = new Wrapper(impl)
}
