package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransportProtocol {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransportProtocol
}
object TransportProtocol {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransportProtocol
  ): zio.aws.ec2.model.TransportProtocol = value match {
    case software.amazon.awssdk.services.ec2.model.TransportProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransportProtocol.TCP =>
      val r = tcp
      r
    case software.amazon.awssdk.services.ec2.model.TransportProtocol.UDP =>
      val r = udp
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TransportProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransportProtocol =
      software.amazon.awssdk.services.ec2.model.TransportProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object tcp extends zio.aws.ec2.model.TransportProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransportProtocol =
      software.amazon.awssdk.services.ec2.model.TransportProtocol.TCP
  }
  case object udp extends zio.aws.ec2.model.TransportProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransportProtocol =
      software.amazon.awssdk.services.ec2.model.TransportProtocol.UDP
  }
}
