package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteTablePropagation(
    transitGatewayAttachmentId: Option[String] = None,
    resourceId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayPropagationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation = {
    import TransitGatewayRouteTablePropagation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteTablePropagation.wrap(buildAwsValue())
}
object TransitGatewayRouteTablePropagation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteTablePropagation =
      zio.aws.ec2.model.TransitGatewayRouteTablePropagation(
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        state.map(value => value)
      )
    def transitGatewayAttachmentId: Option[String]
    def resourceId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def state: Option[zio.aws.ec2.model.TransitGatewayPropagationState]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayPropagationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
  ) extends zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly {
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayPropagationState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPropagationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
  ): zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly =
    new Wrapper(impl)
}
