package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PrefixListResourceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayRoute(
    destinationCidrBlock: Option[String] = None,
    prefixListId: Option[PrefixListResourceId] = None,
    transitGatewayAttachments: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayRouteAttachment]
    ] = None,
    `type`: Option[zio.aws.ec2.model.TransitGatewayRouteType] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayRouteState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRoute = {
    import TransitGatewayRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(
        transitGatewayAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayAttachments)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRoute.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRoute.wrap(buildAwsValue())
}
object TransitGatewayRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRoute =
      zio.aws.ec2.model.TransitGatewayRoute(
        destinationCidrBlock.map(value => value),
        prefixListId.map(value => value),
        transitGatewayAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value => value),
        state.map(value => value)
      )
    def destinationCidrBlock: Option[String]
    def prefixListId: Option[PrefixListResourceId]
    def transitGatewayAttachments
        : Option[List[zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly]]
    def `type`: Option[zio.aws.ec2.model.TransitGatewayRouteType]
    def state: Option[zio.aws.ec2.model.TransitGatewayRouteState]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getTransitGatewayAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayAttachments",
      transitGatewayAttachments
    )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
  ) extends zio.aws.ec2.model.TransitGatewayRoute.ReadOnly {
    override val destinationCidrBlock: Option[String] =
      scala.Option(impl.destinationCidrBlock()).map(value => value: String)
    override val prefixListId: Option[PrefixListResourceId] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val transitGatewayAttachments: Option[
      List[zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly]
    ] = scala
      .Option(impl.transitGatewayAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayRouteAttachment.wrap(item)
        }.toList
      )
    override val `type`: Option[zio.aws.ec2.model.TransitGatewayRouteType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ec2.model.TransitGatewayRouteType.wrap(value))
    override val state: Option[zio.aws.ec2.model.TransitGatewayRouteState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.TransitGatewayRouteState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRoute
  ): zio.aws.ec2.model.TransitGatewayRoute.ReadOnly = new Wrapper(impl)
}
