package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayAttachmentAssociation(
    transitGatewayRouteTableId: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayAssociationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation = {
    import TransitGatewayAttachmentAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.transitGatewayRouteTableId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayAttachmentAssociation.wrap(buildAwsValue())
}
object TransitGatewayAttachmentAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayAttachmentAssociation =
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation(
        transitGatewayRouteTableId.map(value => value),
        state.map(value => value)
      )
    def transitGatewayRouteTableId: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayAssociationState]
    def getTransitGatewayRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAssociationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
  ) extends zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly {
    override val transitGatewayRouteTableId: Option[String] = scala
      .Option(impl.transitGatewayRouteTableId())
      .map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayAssociationState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAssociationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
  ): zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly =
    new Wrapper(impl)
}
