package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TagDescription(
    key: Option[String] = None,
    resourceId: Option[String] = None,
    resourceType: Option[zio.aws.ec2.model.ResourceType] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TagDescription = {
    import TagDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TagDescription
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TagDescription.ReadOnly =
    zio.aws.ec2.model.TagDescription.wrap(buildAwsValue())
}
object TagDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TagDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TagDescription =
      zio.aws.ec2.model.TagDescription(
        key.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        value.map(value => value)
      )
    def key: Option[String]
    def resourceId: Option[String]
    def resourceType: Option[zio.aws.ec2.model.ResourceType]
    def value: Option[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, zio.aws.ec2.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TagDescription
  ) extends zio.aws.ec2.model.TagDescription.ReadOnly {
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType: Option[zio.aws.ec2.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ec2.model.ResourceType.wrap(value))
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TagDescription
  ): zio.aws.ec2.model.TagDescription.ReadOnly = new Wrapper(impl)
}
