package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait StatusName {
  def unwrap: software.amazon.awssdk.services.ec2.model.StatusName
}
object StatusName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.StatusName
  ): zio.aws.ec2.model.StatusName = value match {
    case software.amazon.awssdk.services.ec2.model.StatusName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.StatusName.REACHABILITY =>
      val r = reachability
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.StatusName {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusName =
      software.amazon.awssdk.services.ec2.model.StatusName.UNKNOWN_TO_SDK_VERSION
  }
  case object reachability extends zio.aws.ec2.model.StatusName {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusName =
      software.amazon.awssdk.services.ec2.model.StatusName.REACHABILITY
  }
}
