package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, KeyPairName, ImageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotFleetLaunchSpecification(
    securityGroups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    addressingType: Option[String] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = None,
    imageId: Option[ImageId] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    kernelId: Option[String] = None,
    keyName: Option[KeyPairName] = None,
    monitoring: Option[zio.aws.ec2.model.SpotFleetMonitoring] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = None,
    placement: Option[zio.aws.ec2.model.SpotPlacement] = None,
    ramdiskId: Option[String] = None,
    spotPrice: Option[String] = None,
    subnetId: Option[SubnetId] = None,
    userData: Option[String] = None,
    weightedCapacity: Option[Double] = None,
    tagSpecifications: Option[
      Iterable[zio.aws.ec2.model.SpotFleetTagSpecification]
    ] = None,
    instanceRequirements: Option[zio.aws.ec2.model.InstanceRequirements] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification = {
    import SpotFleetLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
      .builder()
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(addressingType.map(value => value: java.lang.String))(
        _.addressingType
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(weightedCapacity.map(value => value: java.lang.Double))(
        _.weightedCapacity
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.SpotFleetLaunchSpecification.wrap(buildAwsValue())
}
object SpotFleetLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetLaunchSpecification =
      zio.aws.ec2.model.SpotFleetLaunchSpecification(
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addressingType.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId.map(value => value),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        spotPrice.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value),
        weightedCapacity.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceRequirements.map(value => value.asEditable)
      )
    def securityGroups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def addressingType: Option[String]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def imageId: Option[ImageId]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def kernelId: Option[String]
    def keyName: Option[KeyPairName]
    def monitoring: Option[zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly]
    def networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def placement: Option[zio.aws.ec2.model.SpotPlacement.ReadOnly]
    def ramdiskId: Option[String]
    def spotPrice: Option[String]
    def subnetId: Option[SubnetId]
    def userData: Option[String]
    def weightedCapacity: Option[Double]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly]]
    def instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def getSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAddressingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressingType", addressingType)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly] =
      AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getWeightedCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
  ) extends zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly {
    override val securityGroups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val addressingType: Option[String] =
      scala.Option(impl.addressingType()).map(value => value: String)
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      scala
        .Option(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Option[String] =
      scala.Option(impl.kernelId()).map(value => value: String)
    override val keyName: Option[KeyPairName] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Option[zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly] = scala
      .Option(impl.monitoring())
      .map(value => zio.aws.ec2.model.SpotFleetMonitoring.wrap(value))
    override val networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val placement: Option[zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      scala
        .Option(impl.placement())
        .map(value => zio.aws.ec2.model.SpotPlacement.wrap(value))
    override val ramdiskId: Option[String] =
      scala.Option(impl.ramdiskId()).map(value => value: String)
    override val spotPrice: Option[String] =
      scala.Option(impl.spotPrice()).map(value => value: String)
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val weightedCapacity: Option[Double] =
      scala.Option(impl.weightedCapacity()).map(value => value: Double)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly]] =
      scala
        .Option(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SpotFleetTagSpecification.wrap(item)
          }.toList
        )
    override val instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirements.ReadOnly] = scala
      .Option(impl.instanceRequirements())
      .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
  ): zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly = new Wrapper(impl)
}
