package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupName,
  SecurityGroupId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RevokeSecurityGroupIngressRequest(
    cidrIp: Option[String] = None,
    fromPort: Option[Integer] = None,
    groupId: Option[SecurityGroupId] = None,
    groupName: Option[SecurityGroupName] = None,
    ipPermissions: Option[Iterable[zio.aws.ec2.model.IpPermission]] = None,
    ipProtocol: Option[String] = None,
    sourceSecurityGroupName: Option[String] = None,
    sourceSecurityGroupOwnerId: Option[String] = None,
    toPort: Option[Integer] = None,
    securityGroupRuleIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest = {
    import RevokeSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
      .builder()
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        sourceSecurityGroupName.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupName)
      .optionallyWith(
        sourceSecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.sourceSecurityGroupOwnerId)
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(
        securityGroupRuleIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupRuleIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.ReadOnly =
    zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.wrap(buildAwsValue())
}
object RevokeSecurityGroupIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest =
      zio.aws.ec2.model.RevokeSecurityGroupIngressRequest(
        cidrIp.map(value => value),
        fromPort.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipProtocol.map(value => value),
        sourceSecurityGroupName.map(value => value),
        sourceSecurityGroupOwnerId.map(value => value),
        toPort.map(value => value),
        securityGroupRuleIds.map(value => value)
      )
    def cidrIp: Option[String]
    def fromPort: Option[Integer]
    def groupId: Option[SecurityGroupId]
    def groupName: Option[SecurityGroupName]
    def ipPermissions: Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def ipProtocol: Option[String]
    def sourceSecurityGroupName: Option[String]
    def sourceSecurityGroupOwnerId: Option[String]
    def toPort: Option[Integer]
    def securityGroupRuleIds: Option[List[String]]
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getSourceSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceSecurityGroupName", sourceSecurityGroupName)
    def getSourceSecurityGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceSecurityGroupOwnerId",
        sourceSecurityGroupOwnerId
      )
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getSecurityGroupRuleIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupRuleIds", securityGroupRuleIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
  ) extends zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.ReadOnly {
    override val cidrIp: Option[String] =
      scala.Option(impl.cidrIp()).map(value => value: String)
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val groupId: Option[SecurityGroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupName: Option[SecurityGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupName(value))
    override val ipPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val sourceSecurityGroupName: Option[String] =
      scala.Option(impl.sourceSecurityGroupName()).map(value => value: String)
    override val sourceSecurityGroupOwnerId: Option[String] = scala
      .Option(impl.sourceSecurityGroupOwnerId())
      .map(value => value: String)
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val securityGroupRuleIds: Option[List[String]] = scala
      .Option(impl.securityGroupRuleIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest
  ): zio.aws.ec2.model.RevokeSecurityGroupIngressRequest.ReadOnly = new Wrapper(
    impl
  )
}
