package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemovePrefixListEntry(cidr: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry = {
    import RemovePrefixListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry
      .builder()
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly =
    zio.aws.ec2.model.RemovePrefixListEntry.wrap(buildAwsValue())
}
object RemovePrefixListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RemovePrefixListEntry =
      zio.aws.ec2.model.RemovePrefixListEntry(cidr)
    def cidr: String
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry
  ) extends zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly {
    override val cidr: String = impl.cidr(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RemovePrefixListEntry
  ): zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly = new Wrapper(impl)
}
