package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PlatformValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.PlatformValues
}
object PlatformValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PlatformValues
  ): zio.aws.ec2.model.PlatformValues = value match {
    case software.amazon.awssdk.services.ec2.model.PlatformValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PlatformValues.WINDOWS =>
      val r = Windows
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PlatformValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlatformValues =
      software.amazon.awssdk.services.ec2.model.PlatformValues.UNKNOWN_TO_SDK_VERSION
  }
  case object Windows extends zio.aws.ec2.model.PlatformValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlatformValues =
      software.amazon.awssdk.services.ec2.model.PlatformValues.WINDOWS
  }
}
