package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PathStatement(
    packetHeaderStatement: Option[zio.aws.ec2.model.PacketHeaderStatement] =
      None,
    resourceStatement: Option[zio.aws.ec2.model.ResourceStatement] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PathStatement = {
    import PathStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PathStatement
      .builder()
      .optionallyWith(
        packetHeaderStatement.map(value => value.buildAwsValue())
      )(_.packetHeaderStatement)
      .optionallyWith(resourceStatement.map(value => value.buildAwsValue()))(
        _.resourceStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PathStatement.ReadOnly =
    zio.aws.ec2.model.PathStatement.wrap(buildAwsValue())
}
object PathStatement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PathStatement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PathStatement =
      zio.aws.ec2.model.PathStatement(
        packetHeaderStatement.map(value => value.asEditable),
        resourceStatement.map(value => value.asEditable)
      )
    def packetHeaderStatement
        : Option[zio.aws.ec2.model.PacketHeaderStatement.ReadOnly]
    def resourceStatement: Option[zio.aws.ec2.model.ResourceStatement.ReadOnly]
    def getPacketHeaderStatement
        : ZIO[Any, AwsError, zio.aws.ec2.model.PacketHeaderStatement.ReadOnly] =
      AwsError.unwrapOptionField("packetHeaderStatement", packetHeaderStatement)
    def getResourceStatement
        : ZIO[Any, AwsError, zio.aws.ec2.model.ResourceStatement.ReadOnly] =
      AwsError.unwrapOptionField("resourceStatement", resourceStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PathStatement
  ) extends zio.aws.ec2.model.PathStatement.ReadOnly {
    override val packetHeaderStatement
        : Option[zio.aws.ec2.model.PacketHeaderStatement.ReadOnly] = scala
      .Option(impl.packetHeaderStatement())
      .map(value => zio.aws.ec2.model.PacketHeaderStatement.wrap(value))
    override val resourceStatement
        : Option[zio.aws.ec2.model.ResourceStatement.ReadOnly] = scala
      .Option(impl.resourceStatement())
      .map(value => zio.aws.ec2.model.ResourceStatement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PathStatement
  ): zio.aws.ec2.model.PathStatement.ReadOnly = new Wrapper(impl)
}
