package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServiceConfigurationRequest(
    serviceId: VpcEndpointServiceId,
    privateDnsName: Option[String] = None,
    removePrivateDnsName: Option[Boolean] = None,
    acceptanceRequired: Option[Boolean] = None,
    addNetworkLoadBalancerArns: Option[Iterable[String]] = None,
    removeNetworkLoadBalancerArns: Option[Iterable[String]] = None,
    addGatewayLoadBalancerArns: Option[Iterable[String]] = None,
    removeGatewayLoadBalancerArns: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest = {
    import ModifyVpcEndpointServiceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
      .builder()
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        removePrivateDnsName.map(value => value: java.lang.Boolean)
      )(_.removePrivateDnsName)
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        addNetworkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addNetworkLoadBalancerArns)
      .optionallyWith(
        removeNetworkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeNetworkLoadBalancerArns)
      .optionallyWith(
        addGatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addGatewayLoadBalancerArns)
      .optionallyWith(
        removeGatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeGatewayLoadBalancerArns)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServiceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest =
      zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest(
        serviceId,
        privateDnsName.map(value => value),
        removePrivateDnsName.map(value => value),
        acceptanceRequired.map(value => value),
        addNetworkLoadBalancerArns.map(value => value),
        removeNetworkLoadBalancerArns.map(value => value),
        addGatewayLoadBalancerArns.map(value => value),
        removeGatewayLoadBalancerArns.map(value => value)
      )
    def serviceId: VpcEndpointServiceId
    def privateDnsName: Option[String]
    def removePrivateDnsName: Option[Boolean]
    def acceptanceRequired: Option[Boolean]
    def addNetworkLoadBalancerArns: Option[List[String]]
    def removeNetworkLoadBalancerArns: Option[List[String]]
    def addGatewayLoadBalancerArns: Option[List[String]]
    def removeGatewayLoadBalancerArns: Option[List[String]]
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getRemovePrivateDnsName: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removePrivateDnsName", removePrivateDnsName)
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getAddNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addNetworkLoadBalancerArns",
        addNetworkLoadBalancerArns
      )
    def getRemoveNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeNetworkLoadBalancerArns",
        removeNetworkLoadBalancerArns
      )
    def getAddGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addGatewayLoadBalancerArns",
        addGatewayLoadBalancerArns
      )
    def getRemoveGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeGatewayLoadBalancerArns",
        removeGatewayLoadBalancerArns
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest.ReadOnly {
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val removePrivateDnsName: Option[Boolean] =
      scala.Option(impl.removePrivateDnsName()).map(value => value: Boolean)
    override val acceptanceRequired: Option[Boolean] =
      scala.Option(impl.acceptanceRequired()).map(value => value: Boolean)
    override val addNetworkLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.addNetworkLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val removeNetworkLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.removeNetworkLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val addGatewayLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.addGatewayLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val removeGatewayLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.removeGatewayLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
