package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FpgaImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyFpgaImageAttributeRequest(
    fpgaImageId: FpgaImageId,
    attribute: Option[zio.aws.ec2.model.FpgaImageAttributeName] = None,
    operationType: Option[zio.aws.ec2.model.OperationType] = None,
    userIds: Option[Iterable[String]] = None,
    userGroups: Option[Iterable[String]] = None,
    productCodes: Option[Iterable[String]] = None,
    loadPermission: Option[zio.aws.ec2.model.LoadPermissionModifications] =
      None,
    description: Option[String] = None,
    name: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest = {
    import ModifyFpgaImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest
      .builder()
      .fpgaImageId(FpgaImageId.unwrap(fpgaImageId): java.lang.String)
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        userGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userGroups)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(loadPermission.map(value => value.buildAwsValue()))(
        _.loadPermission
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyFpgaImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyFpgaImageAttributeRequest.wrap(buildAwsValue())
}
object ModifyFpgaImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyFpgaImageAttributeRequest =
      zio.aws.ec2.model.ModifyFpgaImageAttributeRequest(
        fpgaImageId,
        attribute.map(value => value),
        operationType.map(value => value),
        userIds.map(value => value),
        userGroups.map(value => value),
        productCodes.map(value => value),
        loadPermission.map(value => value.asEditable),
        description.map(value => value),
        name.map(value => value)
      )
    def fpgaImageId: FpgaImageId
    def attribute: Option[zio.aws.ec2.model.FpgaImageAttributeName]
    def operationType: Option[zio.aws.ec2.model.OperationType]
    def userIds: Option[List[String]]
    def userGroups: Option[List[String]]
    def productCodes: Option[List[String]]
    def loadPermission
        : Option[zio.aws.ec2.model.LoadPermissionModifications.ReadOnly]
    def description: Option[String]
    def name: Option[String]
    def getFpgaImageId: ZIO[Any, Nothing, FpgaImageId] =
      ZIO.succeed(fpgaImageId)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaImageAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getOperationType: ZIO[Any, AwsError, zio.aws.ec2.model.OperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getUserIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getUserGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userGroups", userGroups)
    def getProductCodes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getLoadPermission: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LoadPermissionModifications.ReadOnly
    ] = AwsError.unwrapOptionField("loadPermission", loadPermission)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest
  ) extends zio.aws.ec2.model.ModifyFpgaImageAttributeRequest.ReadOnly {
    override val fpgaImageId: FpgaImageId =
      zio.aws.ec2.model.primitives.FpgaImageId(impl.fpgaImageId())
    override val attribute: Option[zio.aws.ec2.model.FpgaImageAttributeName] =
      scala
        .Option(impl.attribute())
        .map(value => zio.aws.ec2.model.FpgaImageAttributeName.wrap(value))
    override val operationType: Option[zio.aws.ec2.model.OperationType] = scala
      .Option(impl.operationType())
      .map(value => zio.aws.ec2.model.OperationType.wrap(value))
    override val userIds: Option[List[String]] = scala
      .Option(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val userGroups: Option[List[String]] = scala
      .Option(impl.userGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val productCodes: Option[List[String]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val loadPermission
        : Option[zio.aws.ec2.model.LoadPermissionModifications.ReadOnly] = scala
      .Option(impl.loadPermission())
      .map(value => zio.aws.ec2.model.LoadPermissionModifications.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest
  ): zio.aws.ec2.model.ModifyFpgaImageAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
