package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  BurstablePerformanceFlag,
  BareMetalFlag,
  FreeTierEligibleFlag,
  HibernationFlag,
  AutoRecoveryFlag,
  InstanceStorageFlag,
  CurrentGenerationFlag,
  DedicatedHostFlag
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceTypeInfo(
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    currentGeneration: Option[CurrentGenerationFlag] = None,
    freeTierEligible: Option[FreeTierEligibleFlag] = None,
    supportedUsageClasses: Option[Iterable[zio.aws.ec2.model.UsageClassType]] =
      None,
    supportedRootDeviceTypes: Option[
      Iterable[zio.aws.ec2.model.RootDeviceType]
    ] = None,
    supportedVirtualizationTypes: Option[
      Iterable[zio.aws.ec2.model.VirtualizationType]
    ] = None,
    bareMetal: Option[BareMetalFlag] = None,
    hypervisor: Option[zio.aws.ec2.model.InstanceTypeHypervisor] = None,
    processorInfo: Option[zio.aws.ec2.model.ProcessorInfo] = None,
    vCpuInfo: Option[zio.aws.ec2.model.VCpuInfo] = None,
    memoryInfo: Option[zio.aws.ec2.model.MemoryInfo] = None,
    instanceStorageSupported: Option[InstanceStorageFlag] = None,
    instanceStorageInfo: Option[zio.aws.ec2.model.InstanceStorageInfo] = None,
    ebsInfo: Option[zio.aws.ec2.model.EbsInfo] = None,
    networkInfo: Option[zio.aws.ec2.model.NetworkInfo] = None,
    gpuInfo: Option[zio.aws.ec2.model.GpuInfo] = None,
    fpgaInfo: Option[zio.aws.ec2.model.FpgaInfo] = None,
    placementGroupInfo: Option[zio.aws.ec2.model.PlacementGroupInfo] = None,
    inferenceAcceleratorInfo: Option[
      zio.aws.ec2.model.InferenceAcceleratorInfo
    ] = None,
    hibernationSupported: Option[HibernationFlag] = None,
    burstablePerformanceSupported: Option[BurstablePerformanceFlag] = None,
    dedicatedHostsSupported: Option[DedicatedHostFlag] = None,
    autoRecoverySupported: Option[AutoRecoveryFlag] = None,
    supportedBootModes: Option[Iterable[zio.aws.ec2.model.BootModeType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceTypeInfo = {
    import InstanceTypeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        currentGeneration.map(value =>
          CurrentGenerationFlag.unwrap(value): java.lang.Boolean
        )
      )(_.currentGeneration)
      .optionallyWith(
        freeTierEligible.map(value =>
          FreeTierEligibleFlag.unwrap(value): java.lang.Boolean
        )
      )(_.freeTierEligible)
      .optionallyWith(
        supportedUsageClasses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedUsageClassesWithStrings)
      .optionallyWith(
        supportedRootDeviceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedRootDeviceTypesWithStrings)
      .optionallyWith(
        supportedVirtualizationTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedVirtualizationTypesWithStrings)
      .optionallyWith(
        bareMetal.map(value => BareMetalFlag.unwrap(value): java.lang.Boolean)
      )(_.bareMetal)
      .optionallyWith(hypervisor.map(value => value.unwrap))(_.hypervisor)
      .optionallyWith(processorInfo.map(value => value.buildAwsValue()))(
        _.processorInfo
      )
      .optionallyWith(vCpuInfo.map(value => value.buildAwsValue()))(_.vCpuInfo)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .optionallyWith(
        instanceStorageSupported.map(value =>
          InstanceStorageFlag.unwrap(value): java.lang.Boolean
        )
      )(_.instanceStorageSupported)
      .optionallyWith(instanceStorageInfo.map(value => value.buildAwsValue()))(
        _.instanceStorageInfo
      )
      .optionallyWith(ebsInfo.map(value => value.buildAwsValue()))(_.ebsInfo)
      .optionallyWith(networkInfo.map(value => value.buildAwsValue()))(
        _.networkInfo
      )
      .optionallyWith(gpuInfo.map(value => value.buildAwsValue()))(_.gpuInfo)
      .optionallyWith(fpgaInfo.map(value => value.buildAwsValue()))(_.fpgaInfo)
      .optionallyWith(placementGroupInfo.map(value => value.buildAwsValue()))(
        _.placementGroupInfo
      )
      .optionallyWith(
        inferenceAcceleratorInfo.map(value => value.buildAwsValue())
      )(_.inferenceAcceleratorInfo)
      .optionallyWith(
        hibernationSupported.map(value =>
          HibernationFlag.unwrap(value): java.lang.Boolean
        )
      )(_.hibernationSupported)
      .optionallyWith(
        burstablePerformanceSupported.map(value =>
          BurstablePerformanceFlag.unwrap(value): java.lang.Boolean
        )
      )(_.burstablePerformanceSupported)
      .optionallyWith(
        dedicatedHostsSupported.map(value =>
          DedicatedHostFlag.unwrap(value): java.lang.Boolean
        )
      )(_.dedicatedHostsSupported)
      .optionallyWith(
        autoRecoverySupported.map(value =>
          AutoRecoveryFlag.unwrap(value): java.lang.Boolean
        )
      )(_.autoRecoverySupported)
      .optionallyWith(
        supportedBootModes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedBootModesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceTypeInfo.ReadOnly =
    zio.aws.ec2.model.InstanceTypeInfo.wrap(buildAwsValue())
}
object InstanceTypeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceTypeInfo =
      zio.aws.ec2.model.InstanceTypeInfo(
        instanceType.map(value => value),
        currentGeneration.map(value => value),
        freeTierEligible.map(value => value),
        supportedUsageClasses.map(value => value),
        supportedRootDeviceTypes.map(value => value),
        supportedVirtualizationTypes.map(value => value),
        bareMetal.map(value => value),
        hypervisor.map(value => value),
        processorInfo.map(value => value.asEditable),
        vCpuInfo.map(value => value.asEditable),
        memoryInfo.map(value => value.asEditable),
        instanceStorageSupported.map(value => value),
        instanceStorageInfo.map(value => value.asEditable),
        ebsInfo.map(value => value.asEditable),
        networkInfo.map(value => value.asEditable),
        gpuInfo.map(value => value.asEditable),
        fpgaInfo.map(value => value.asEditable),
        placementGroupInfo.map(value => value.asEditable),
        inferenceAcceleratorInfo.map(value => value.asEditable),
        hibernationSupported.map(value => value),
        burstablePerformanceSupported.map(value => value),
        dedicatedHostsSupported.map(value => value),
        autoRecoverySupported.map(value => value),
        supportedBootModes.map(value => value)
      )
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def currentGeneration: Option[CurrentGenerationFlag]
    def freeTierEligible: Option[FreeTierEligibleFlag]
    def supportedUsageClasses: Option[List[zio.aws.ec2.model.UsageClassType]]
    def supportedRootDeviceTypes: Option[List[zio.aws.ec2.model.RootDeviceType]]
    def supportedVirtualizationTypes
        : Option[List[zio.aws.ec2.model.VirtualizationType]]
    def bareMetal: Option[BareMetalFlag]
    def hypervisor: Option[zio.aws.ec2.model.InstanceTypeHypervisor]
    def processorInfo: Option[zio.aws.ec2.model.ProcessorInfo.ReadOnly]
    def vCpuInfo: Option[zio.aws.ec2.model.VCpuInfo.ReadOnly]
    def memoryInfo: Option[zio.aws.ec2.model.MemoryInfo.ReadOnly]
    def instanceStorageSupported: Option[InstanceStorageFlag]
    def instanceStorageInfo
        : Option[zio.aws.ec2.model.InstanceStorageInfo.ReadOnly]
    def ebsInfo: Option[zio.aws.ec2.model.EbsInfo.ReadOnly]
    def networkInfo: Option[zio.aws.ec2.model.NetworkInfo.ReadOnly]
    def gpuInfo: Option[zio.aws.ec2.model.GpuInfo.ReadOnly]
    def fpgaInfo: Option[zio.aws.ec2.model.FpgaInfo.ReadOnly]
    def placementGroupInfo
        : Option[zio.aws.ec2.model.PlacementGroupInfo.ReadOnly]
    def inferenceAcceleratorInfo
        : Option[zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly]
    def hibernationSupported: Option[HibernationFlag]
    def burstablePerformanceSupported: Option[BurstablePerformanceFlag]
    def dedicatedHostsSupported: Option[DedicatedHostFlag]
    def autoRecoverySupported: Option[AutoRecoveryFlag]
    def supportedBootModes: Option[List[zio.aws.ec2.model.BootModeType]]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getCurrentGeneration: ZIO[Any, AwsError, CurrentGenerationFlag] =
      AwsError.unwrapOptionField("currentGeneration", currentGeneration)
    def getFreeTierEligible: ZIO[Any, AwsError, FreeTierEligibleFlag] =
      AwsError.unwrapOptionField("freeTierEligible", freeTierEligible)
    def getSupportedUsageClasses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.UsageClassType]] =
      AwsError.unwrapOptionField("supportedUsageClasses", supportedUsageClasses)
    def getSupportedRootDeviceTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RootDeviceType]] = AwsError
      .unwrapOptionField("supportedRootDeviceTypes", supportedRootDeviceTypes)
    def getSupportedVirtualizationTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VirtualizationType]] =
      AwsError.unwrapOptionField(
        "supportedVirtualizationTypes",
        supportedVirtualizationTypes
      )
    def getBareMetal: ZIO[Any, AwsError, BareMetalFlag] =
      AwsError.unwrapOptionField("bareMetal", bareMetal)
    def getHypervisor
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceTypeHypervisor] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getProcessorInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.ProcessorInfo.ReadOnly] =
      AwsError.unwrapOptionField("processorInfo", processorInfo)
    def getVCpuInfo: ZIO[Any, AwsError, zio.aws.ec2.model.VCpuInfo.ReadOnly] =
      AwsError.unwrapOptionField("vCpuInfo", vCpuInfo)
    def getMemoryInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.MemoryInfo.ReadOnly] =
      AwsError.unwrapOptionField("memoryInfo", memoryInfo)
    def getInstanceStorageSupported: ZIO[Any, AwsError, InstanceStorageFlag] =
      AwsError.unwrapOptionField(
        "instanceStorageSupported",
        instanceStorageSupported
      )
    def getInstanceStorageInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStorageInfo.ReadOnly] =
      AwsError.unwrapOptionField("instanceStorageInfo", instanceStorageInfo)
    def getEbsInfo: ZIO[Any, AwsError, zio.aws.ec2.model.EbsInfo.ReadOnly] =
      AwsError.unwrapOptionField("ebsInfo", ebsInfo)
    def getNetworkInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInfo.ReadOnly] =
      AwsError.unwrapOptionField("networkInfo", networkInfo)
    def getGpuInfo: ZIO[Any, AwsError, zio.aws.ec2.model.GpuInfo.ReadOnly] =
      AwsError.unwrapOptionField("gpuInfo", gpuInfo)
    def getFpgaInfo: ZIO[Any, AwsError, zio.aws.ec2.model.FpgaInfo.ReadOnly] =
      AwsError.unwrapOptionField("fpgaInfo", fpgaInfo)
    def getPlacementGroupInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.PlacementGroupInfo.ReadOnly] =
      AwsError.unwrapOptionField("placementGroupInfo", placementGroupInfo)
    def getInferenceAcceleratorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceAcceleratorInfo",
      inferenceAcceleratorInfo
    )
    def getHibernationSupported: ZIO[Any, AwsError, HibernationFlag] =
      AwsError.unwrapOptionField("hibernationSupported", hibernationSupported)
    def getBurstablePerformanceSupported
        : ZIO[Any, AwsError, BurstablePerformanceFlag] =
      AwsError.unwrapOptionField(
        "burstablePerformanceSupported",
        burstablePerformanceSupported
      )
    def getDedicatedHostsSupported: ZIO[Any, AwsError, DedicatedHostFlag] =
      AwsError.unwrapOptionField(
        "dedicatedHostsSupported",
        dedicatedHostsSupported
      )
    def getAutoRecoverySupported: ZIO[Any, AwsError, AutoRecoveryFlag] =
      AwsError.unwrapOptionField("autoRecoverySupported", autoRecoverySupported)
    def getSupportedBootModes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.BootModeType]] =
      AwsError.unwrapOptionField("supportedBootModes", supportedBootModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
  ) extends zio.aws.ec2.model.InstanceTypeInfo.ReadOnly {
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val currentGeneration: Option[CurrentGenerationFlag] = scala
      .Option(impl.currentGeneration())
      .map(value => zio.aws.ec2.model.primitives.CurrentGenerationFlag(value))
    override val freeTierEligible: Option[FreeTierEligibleFlag] = scala
      .Option(impl.freeTierEligible())
      .map(value => zio.aws.ec2.model.primitives.FreeTierEligibleFlag(value))
    override val supportedUsageClasses
        : Option[List[zio.aws.ec2.model.UsageClassType]] = scala
      .Option(impl.supportedUsageClasses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.UsageClassType.wrap(item)
        }.toList
      )
    override val supportedRootDeviceTypes
        : Option[List[zio.aws.ec2.model.RootDeviceType]] = scala
      .Option(impl.supportedRootDeviceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.RootDeviceType.wrap(item)
        }.toList
      )
    override val supportedVirtualizationTypes
        : Option[List[zio.aws.ec2.model.VirtualizationType]] = scala
      .Option(impl.supportedVirtualizationTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VirtualizationType.wrap(item)
        }.toList
      )
    override val bareMetal: Option[BareMetalFlag] = scala
      .Option(impl.bareMetal())
      .map(value => zio.aws.ec2.model.primitives.BareMetalFlag(value))
    override val hypervisor: Option[zio.aws.ec2.model.InstanceTypeHypervisor] =
      scala
        .Option(impl.hypervisor())
        .map(value => zio.aws.ec2.model.InstanceTypeHypervisor.wrap(value))
    override val processorInfo
        : Option[zio.aws.ec2.model.ProcessorInfo.ReadOnly] = scala
      .Option(impl.processorInfo())
      .map(value => zio.aws.ec2.model.ProcessorInfo.wrap(value))
    override val vCpuInfo: Option[zio.aws.ec2.model.VCpuInfo.ReadOnly] = scala
      .Option(impl.vCpuInfo())
      .map(value => zio.aws.ec2.model.VCpuInfo.wrap(value))
    override val memoryInfo: Option[zio.aws.ec2.model.MemoryInfo.ReadOnly] =
      scala
        .Option(impl.memoryInfo())
        .map(value => zio.aws.ec2.model.MemoryInfo.wrap(value))
    override val instanceStorageSupported: Option[InstanceStorageFlag] = scala
      .Option(impl.instanceStorageSupported())
      .map(value => zio.aws.ec2.model.primitives.InstanceStorageFlag(value))
    override val instanceStorageInfo
        : Option[zio.aws.ec2.model.InstanceStorageInfo.ReadOnly] = scala
      .Option(impl.instanceStorageInfo())
      .map(value => zio.aws.ec2.model.InstanceStorageInfo.wrap(value))
    override val ebsInfo: Option[zio.aws.ec2.model.EbsInfo.ReadOnly] = scala
      .Option(impl.ebsInfo())
      .map(value => zio.aws.ec2.model.EbsInfo.wrap(value))
    override val networkInfo: Option[zio.aws.ec2.model.NetworkInfo.ReadOnly] =
      scala
        .Option(impl.networkInfo())
        .map(value => zio.aws.ec2.model.NetworkInfo.wrap(value))
    override val gpuInfo: Option[zio.aws.ec2.model.GpuInfo.ReadOnly] = scala
      .Option(impl.gpuInfo())
      .map(value => zio.aws.ec2.model.GpuInfo.wrap(value))
    override val fpgaInfo: Option[zio.aws.ec2.model.FpgaInfo.ReadOnly] = scala
      .Option(impl.fpgaInfo())
      .map(value => zio.aws.ec2.model.FpgaInfo.wrap(value))
    override val placementGroupInfo
        : Option[zio.aws.ec2.model.PlacementGroupInfo.ReadOnly] = scala
      .Option(impl.placementGroupInfo())
      .map(value => zio.aws.ec2.model.PlacementGroupInfo.wrap(value))
    override val inferenceAcceleratorInfo
        : Option[zio.aws.ec2.model.InferenceAcceleratorInfo.ReadOnly] = scala
      .Option(impl.inferenceAcceleratorInfo())
      .map(value => zio.aws.ec2.model.InferenceAcceleratorInfo.wrap(value))
    override val hibernationSupported: Option[HibernationFlag] = scala
      .Option(impl.hibernationSupported())
      .map(value => zio.aws.ec2.model.primitives.HibernationFlag(value))
    override val burstablePerformanceSupported
        : Option[BurstablePerformanceFlag] = scala
      .Option(impl.burstablePerformanceSupported())
      .map(value =>
        zio.aws.ec2.model.primitives.BurstablePerformanceFlag(value)
      )
    override val dedicatedHostsSupported: Option[DedicatedHostFlag] = scala
      .Option(impl.dedicatedHostsSupported())
      .map(value => zio.aws.ec2.model.primitives.DedicatedHostFlag(value))
    override val autoRecoverySupported: Option[AutoRecoveryFlag] = scala
      .Option(impl.autoRecoverySupported())
      .map(value => zio.aws.ec2.model.primitives.AutoRecoveryFlag(value))
    override val supportedBootModes
        : Option[List[zio.aws.ec2.model.BootModeType]] = scala
      .Option(impl.supportedBootModes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BootModeType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceTypeInfo
  ): zio.aws.ec2.model.InstanceTypeInfo.ReadOnly = new Wrapper(impl)
}
