package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait HypervisorType {
  def unwrap: software.amazon.awssdk.services.ec2.model.HypervisorType
}
object HypervisorType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.HypervisorType
  ): zio.aws.ec2.model.HypervisorType = value match {
    case software.amazon.awssdk.services.ec2.model.HypervisorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.HypervisorType.OVM =>
      val r = ovm
      r
    case software.amazon.awssdk.services.ec2.model.HypervisorType.XEN =>
      val r = xen
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.HypervisorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HypervisorType =
      software.amazon.awssdk.services.ec2.model.HypervisorType.UNKNOWN_TO_SDK_VERSION
  }
  case object ovm extends zio.aws.ec2.model.HypervisorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HypervisorType =
      software.amazon.awssdk.services.ec2.model.HypervisorType.OVM
  }
  case object xen extends zio.aws.ec2.model.HypervisorType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HypervisorType =
      software.amazon.awssdk.services.ec2.model.HypervisorType.XEN
  }
}
