package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoresResponse(
    successful: Option[
      Iterable[zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem]
    ] = None,
    unsuccessful: Option[
      Iterable[zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse = {
    import EnableFastSnapshotRestoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.wrap(buildAwsValue())
}
object EnableFastSnapshotRestoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoresResponse =
      zio.aws.ec2.model.EnableFastSnapshotRestoresResponse(
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful: Option[
      List[zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly]
    ]
    def unsuccessful: Option[
      List[zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.ReadOnly]
    ]
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly {
    override val successful: Option[
      List[zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.ReadOnly]
    ] = scala
      .Option(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem.wrap(item)
        }.toList
      )
    override val unsuccessful: Option[
      List[zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.ReadOnly]
    ] = scala
      .Option(impl.unsuccessful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse
  ): zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly =
    new Wrapper(impl)
}
