package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesListingsResponse(
    reservedInstancesListings: Option[
      Iterable[zio.aws.ec2.model.ReservedInstancesListing]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse = {
    import DescribeReservedInstancesListingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse
      .builder()
      .optionallyWith(
        reservedInstancesListings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstancesListings)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesListingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesListingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeReservedInstancesListingsResponse =
      zio.aws.ec2.model.DescribeReservedInstancesListingsResponse(
        reservedInstancesListings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedInstancesListings
        : Option[List[zio.aws.ec2.model.ReservedInstancesListing.ReadOnly]]
    def getReservedInstancesListings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesListing.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedInstancesListings",
      reservedInstancesListings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse
  ) extends zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly {
    override val reservedInstancesListings
        : Option[List[zio.aws.ec2.model.ReservedInstancesListing.ReadOnly]] =
      scala
        .Option(impl.reservedInstancesListings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ReservedInstancesListing.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse
  ): zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly =
    new Wrapper(impl)
}
