package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfacesResponse(
    networkInterfaces: Option[Iterable[zio.aws.ec2.model.NetworkInterface]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse = {
    import DescribeNetworkInterfacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
      .builder()
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfacesResponse.wrap(buildAwsValue())
}
object DescribeNetworkInterfacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInterfacesResponse =
      zio.aws.ec2.model.DescribeNetworkInterfacesResponse(
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInterfaces
        : Option[List[zio.aws.ec2.model.NetworkInterface.ReadOnly]]
    def nextToken: Option[String]
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly {
    override val networkInterfaces
        : Option[List[zio.aws.ec2.model.NetworkInterface.ReadOnly]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInterface.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
  ): zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
