package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLaunchTemplatesResponse(
    launchTemplates: Option[Iterable[zio.aws.ec2.model.LaunchTemplate]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse = {
    import DescribeLaunchTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse
      .builder()
      .optionallyWith(
        launchTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplates)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLaunchTemplatesResponse.wrap(buildAwsValue())
}
object DescribeLaunchTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLaunchTemplatesResponse =
      zio.aws.ec2.model.DescribeLaunchTemplatesResponse(
        launchTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def launchTemplates: Option[List[zio.aws.ec2.model.LaunchTemplate.ReadOnly]]
    def nextToken: Option[String]
    def getLaunchTemplates
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.LaunchTemplate.ReadOnly]] =
      AwsError.unwrapOptionField("launchTemplates", launchTemplates)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse
  ) extends zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly {
    override val launchTemplates
        : Option[List[zio.aws.ec2.model.LaunchTemplate.ReadOnly]] = scala
      .Option(impl.launchTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplate.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse
  ): zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
