package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClassicLinkInstancesResponse(
    instances: Option[Iterable[zio.aws.ec2.model.ClassicLinkInstance]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse = {
    import DescribeClassicLinkInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.wrap(buildAwsValue())
}
object DescribeClassicLinkInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClassicLinkInstancesResponse =
      zio.aws.ec2.model.DescribeClassicLinkInstancesResponse(
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instances: Option[List[zio.aws.ec2.model.ClassicLinkInstance.ReadOnly]]
    def nextToken: Option[String]
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClassicLinkInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse
  ) extends zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly {
    override val instances
        : Option[List[zio.aws.ec2.model.ClassicLinkInstance.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ClassicLinkInstance.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse
  ): zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
