package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolEc2Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeprovisionPublicIpv4PoolCidrResponse(
    poolId: Option[Ipv4PoolEc2Id] = None,
    deprovisionedAddresses: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse = {
    import DeprovisionPublicIpv4PoolCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse
      .builder()
      .optionallyWith(
        poolId.map(value => Ipv4PoolEc2Id.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(
        deprovisionedAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.deprovisionedAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly =
    zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse
      .wrap(buildAwsValue())
}
object DeprovisionPublicIpv4PoolCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse =
      zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse(
        poolId.map(value => value),
        deprovisionedAddresses.map(value => value)
      )
    def poolId: Option[Ipv4PoolEc2Id]
    def deprovisionedAddresses: Option[List[String]]
    def getPoolId: ZIO[Any, AwsError, Ipv4PoolEc2Id] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getDeprovisionedAddresses: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("deprovisionedAddresses", deprovisionedAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse
  ) extends zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly {
    override val poolId: Option[Ipv4PoolEc2Id] = scala
      .Option(impl.poolId())
      .map(value => zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(value))
    override val deprovisionedAddresses: Option[List[String]] = scala
      .Option(impl.deprovisionedAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse
  ): zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly =
    new Wrapper(impl)
}
