package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateVersionsResponseErrorItem(
    launchTemplateId: Option[String] = None,
    launchTemplateName: Option[String] = None,
    versionNumber: Option[Long] = None,
    responseError: Option[zio.aws.ec2.model.ResponseError] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem = {
    import DeleteLaunchTemplateVersionsResponseErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(launchTemplateName.map(value => value: java.lang.String))(
        _.launchTemplateName
      )
      .optionallyWith(versionNumber.map(value => value: java.lang.Long))(
        _.versionNumber
      )
      .optionallyWith(responseError.map(value => value.buildAwsValue()))(
        _.responseError
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
      .wrap(buildAwsValue())
}
object DeleteLaunchTemplateVersionsResponseErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem =
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versionNumber.map(value => value),
        responseError.map(value => value.asEditable)
      )
    def launchTemplateId: Option[String]
    def launchTemplateName: Option[String]
    def versionNumber: Option[Long]
    def responseError: Option[zio.aws.ec2.model.ResponseError.ReadOnly]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getResponseError
        : ZIO[Any, AwsError, zio.aws.ec2.model.ResponseError.ReadOnly] =
      AwsError.unwrapOptionField("responseError", responseError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly {
    override val launchTemplateId: Option[String] =
      scala.Option(impl.launchTemplateId()).map(value => value: String)
    override val launchTemplateName: Option[String] =
      scala.Option(impl.launchTemplateName()).map(value => value: String)
    override val versionNumber: Option[Long] =
      scala.Option(impl.versionNumber()).map(value => value: Long)
    override val responseError
        : Option[zio.aws.ec2.model.ResponseError.ReadOnly] = scala
      .Option(impl.responseError())
      .map(value => zio.aws.ec2.model.ResponseError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem
  ): zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem.ReadOnly =
    new Wrapper(impl)
}
