package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateKeyPairRequest(
    keyName: String,
    keyType: Option[zio.aws.ec2.model.KeyType] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest = {
    import CreateKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
      .builder()
      .keyName(keyName: java.lang.String)
      .optionallyWith(keyType.map(value => value.unwrap))(_.keyType)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateKeyPairRequest.ReadOnly =
    zio.aws.ec2.model.CreateKeyPairRequest.wrap(buildAwsValue())
}
object CreateKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateKeyPairRequest =
      zio.aws.ec2.model.CreateKeyPairRequest(
        keyName,
        keyType.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyName: String
    def keyType: Option[zio.aws.ec2.model.KeyType]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getKeyName: ZIO[Any, Nothing, String] = ZIO.succeed(keyName)
    def getKeyType: ZIO[Any, AwsError, zio.aws.ec2.model.KeyType] =
      AwsError.unwrapOptionField("keyType", keyType)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
  ) extends zio.aws.ec2.model.CreateKeyPairRequest.ReadOnly {
    override val keyName: String = impl.keyName(): String
    override val keyType: Option[zio.aws.ec2.model.KeyType] = scala
      .Option(impl.keyType())
      .map(value => zio.aws.ec2.model.KeyType.wrap(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest
  ): zio.aws.ec2.model.CreateKeyPairRequest.ReadOnly = new Wrapper(impl)
}
