package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClientVpnEndpointResponse(
    clientVpnEndpointId: Option[String] = None,
    status: Option[zio.aws.ec2.model.ClientVpnEndpointStatus] = None,
    dnsName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse = {
    import CreateClientVpnEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly =
    zio.aws.ec2.model.CreateClientVpnEndpointResponse.wrap(buildAwsValue())
}
object CreateClientVpnEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateClientVpnEndpointResponse =
      zio.aws.ec2.model.CreateClientVpnEndpointResponse(
        clientVpnEndpointId.map(value => value),
        status.map(value => value.asEditable),
        dnsName.map(value => value)
      )
    def clientVpnEndpointId: Option[String]
    def status: Option[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly]
    def dnsName: Option[String]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsName", dnsName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse
  ) extends zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly {
    override val clientVpnEndpointId: Option[String] =
      scala.Option(impl.clientVpnEndpointId()).map(value => value: String)
    override val status
        : Option[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.ClientVpnEndpointStatus.wrap(value))
    override val dnsName: Option[String] =
      scala.Option(impl.dnsName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse
  ): zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
