package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionNotificationType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ConnectionNotificationType
}
object ConnectionNotificationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ConnectionNotificationType
  ): zio.aws.ec2.model.ConnectionNotificationType = value match {
    case software.amazon.awssdk.services.ec2.model.ConnectionNotificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ConnectionNotificationType.TOPIC =>
      val r = Topic
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ConnectionNotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectionNotificationType =
      software.amazon.awssdk.services.ec2.model.ConnectionNotificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Topic extends zio.aws.ec2.model.ConnectionNotificationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectionNotificationType =
      software.amazon.awssdk.services.ec2.model.ConnectionNotificationType.TOPIC
  }
}
