package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientVpnRoute(
    clientVpnEndpointId: Option[String] = None,
    destinationCidr: Option[String] = None,
    targetSubnet: Option[String] = None,
    `type`: Option[String] = None,
    origin: Option[String] = None,
    status: Option[zio.aws.ec2.model.ClientVpnRouteStatus] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnRoute = {
    import ClientVpnRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnRoute
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(targetSubnet.map(value => value: java.lang.String))(
        _.targetSubnet
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(origin.map(value => value: java.lang.String))(_.origin)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnRoute.ReadOnly =
    zio.aws.ec2.model.ClientVpnRoute.wrap(buildAwsValue())
}
object ClientVpnRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnRoute =
      zio.aws.ec2.model.ClientVpnRoute(
        clientVpnEndpointId.map(value => value),
        destinationCidr.map(value => value),
        targetSubnet.map(value => value),
        `type`.map(value => value),
        origin.map(value => value),
        status.map(value => value.asEditable),
        description.map(value => value)
      )
    def clientVpnEndpointId: Option[String]
    def destinationCidr: Option[String]
    def targetSubnet: Option[String]
    def `type`: Option[String]
    def origin: Option[String]
    def status: Option[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly]
    def description: Option[String]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getTargetSubnet: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSubnet", targetSubnet)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getOrigin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("origin", origin)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnRoute
  ) extends zio.aws.ec2.model.ClientVpnRoute.ReadOnly {
    override val clientVpnEndpointId: Option[String] =
      scala.Option(impl.clientVpnEndpointId()).map(value => value: String)
    override val destinationCidr: Option[String] =
      scala.Option(impl.destinationCidr()).map(value => value: String)
    override val targetSubnet: Option[String] =
      scala.Option(impl.targetSubnet()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val origin: Option[String] =
      scala.Option(impl.origin()).map(value => value: String)
    override val status
        : Option[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.ClientVpnRouteStatus.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnRoute
  ): zio.aws.ec2.model.ClientVpnRoute.ReadOnly = new Wrapper(impl)
}
