package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelImportTaskResponse(
    importTaskId: Option[String] = None,
    previousState: Option[String] = None,
    state: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse = {
    import CancelImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
      .builder()
      .optionallyWith(importTaskId.map(value => value: java.lang.String))(
        _.importTaskId
      )
      .optionallyWith(previousState.map(value => value: java.lang.String))(
        _.previousState
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly =
    zio.aws.ec2.model.CancelImportTaskResponse.wrap(buildAwsValue())
}
object CancelImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelImportTaskResponse =
      zio.aws.ec2.model.CancelImportTaskResponse(
        importTaskId.map(value => value),
        previousState.map(value => value),
        state.map(value => value)
      )
    def importTaskId: Option[String]
    def previousState: Option[String]
    def state: Option[String]
    def getImportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getPreviousState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("previousState", previousState)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
  ) extends zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly {
    override val importTaskId: Option[String] =
      scala.Option(impl.importTaskId()).map(value => value: String)
    override val previousState: Option[String] =
      scala.Option(impl.previousState()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse
  ): zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly = new Wrapper(impl)
}
