package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ByoipCidr(
    cidr: Option[String] = None,
    description: Option[String] = None,
    statusMessage: Option[String] = None,
    state: Option[zio.aws.ec2.model.ByoipCidrState] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.ByoipCidr = {
    import ByoipCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ByoipCidr
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ByoipCidr.ReadOnly =
    zio.aws.ec2.model.ByoipCidr.wrap(buildAwsValue())
}
object ByoipCidr {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ByoipCidr] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ByoipCidr = zio.aws.ec2.model.ByoipCidr(
      cidr.map(value => value),
      description.map(value => value),
      statusMessage.map(value => value),
      state.map(value => value)
    )
    def cidr: Option[String]
    def description: Option[String]
    def statusMessage: Option[String]
    def state: Option[zio.aws.ec2.model.ByoipCidrState]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ByoipCidrState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ByoipCidr
  ) extends zio.aws.ec2.model.ByoipCidr.ReadOnly {
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.ByoipCidrState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.ByoipCidrState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ByoipCidr
  ): zio.aws.ec2.model.ByoipCidr.ReadOnly = new Wrapper(impl)
}
