package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BlockDeviceMapping(
    deviceName: Option[String] = None,
    virtualName: Option[String] = None,
    ebs: Option[zio.aws.ec2.model.EbsBlockDevice] = None,
    noDevice: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.BlockDeviceMapping = {
    import BlockDeviceMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BlockDeviceMapping
      .builder()
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(virtualName.map(value => value: java.lang.String))(
        _.virtualName
      )
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .optionallyWith(noDevice.map(value => value: java.lang.String))(
        _.noDevice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BlockDeviceMapping.ReadOnly =
    zio.aws.ec2.model.BlockDeviceMapping.wrap(buildAwsValue())
}
object BlockDeviceMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.BlockDeviceMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BlockDeviceMapping =
      zio.aws.ec2.model.BlockDeviceMapping(
        deviceName.map(value => value),
        virtualName.map(value => value),
        ebs.map(value => value.asEditable),
        noDevice.map(value => value)
      )
    def deviceName: Option[String]
    def virtualName: Option[String]
    def ebs: Option[zio.aws.ec2.model.EbsBlockDevice.ReadOnly]
    def noDevice: Option[String]
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getVirtualName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("virtualName", virtualName)
    def getEbs: ZIO[Any, AwsError, zio.aws.ec2.model.EbsBlockDevice.ReadOnly] =
      AwsError.unwrapOptionField("ebs", ebs)
    def getNoDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("noDevice", noDevice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BlockDeviceMapping
  ) extends zio.aws.ec2.model.BlockDeviceMapping.ReadOnly {
    override val deviceName: Option[String] =
      scala.Option(impl.deviceName()).map(value => value: String)
    override val virtualName: Option[String] =
      scala.Option(impl.virtualName()).map(value => value: String)
    override val ebs: Option[zio.aws.ec2.model.EbsBlockDevice.ReadOnly] = scala
      .Option(impl.ebs())
      .map(value => zio.aws.ec2.model.EbsBlockDevice.wrap(value))
    override val noDevice: Option[String] =
      scala.Option(impl.noDevice()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BlockDeviceMapping
  ): zio.aws.ec2.model.BlockDeviceMapping.ReadOnly = new Wrapper(impl)
}
