package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BaselineEbsBandwidthMbpsRequest(
    min: Option[Integer] = None,
    max: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbpsRequest = {
    import BaselineEbsBandwidthMbpsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbpsRequest
      .builder()
      .optionallyWith(
        min.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.min)
      .optionallyWith(
        max.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.ReadOnly =
    zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.wrap(buildAwsValue())
}
object BaselineEbsBandwidthMbpsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbpsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest =
      zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest(
        min.map(value => value),
        max.map(value => value)
      )
    def min: Option[Integer]
    def max: Option[Integer]
    def getMin: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbpsRequest
  ) extends zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.ReadOnly {
    override val min: Option[Integer] = scala
      .Option(impl.min())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val max: Option[Integer] = scala
      .Option(impl.max())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbpsRequest
  ): zio.aws.ec2.model.BaselineEbsBandwidthMbpsRequest.ReadOnly = new Wrapper(
    impl
  )
}
