package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateSubnetCidrBlockResponse(
    ipv6CidrBlockAssociation: Option[
      zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation
    ] = None,
    subnetId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse = {
    import AssociateSubnetCidrBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse
      .builder()
      .optionallyWith(
        ipv6CidrBlockAssociation.map(value => value.buildAwsValue())
      )(_.ipv6CidrBlockAssociation)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly =
    zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.wrap(buildAwsValue())
}
object AssociateSubnetCidrBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateSubnetCidrBlockResponse =
      zio.aws.ec2.model.AssociateSubnetCidrBlockResponse(
        ipv6CidrBlockAssociation.map(value => value.asEditable),
        subnetId.map(value => value)
      )
    def ipv6CidrBlockAssociation
        : Option[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly]
    def subnetId: Option[String]
    def getIpv6CidrBlockAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociation",
      ipv6CidrBlockAssociation
    )
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse
  ) extends zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly {
    override val ipv6CidrBlockAssociation
        : Option[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly] =
      scala
        .Option(impl.ipv6CidrBlockAssociation())
        .map(value =>
          zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.wrap(value)
        )
    override val subnetId: Option[String] =
      scala.Option(impl.subnetId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse
  ): zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly = new Wrapper(
    impl
  )
}
