package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AllowsMultipleInstanceTypes {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes
}
object AllowsMultipleInstanceTypes {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes
  ): zio.aws.ec2.model.AllowsMultipleInstanceTypes = value match {
    case software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes.ON =>
      val r = on
      r
    case software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes.OFF =>
      val r = off
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AllowsMultipleInstanceTypes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes =
      software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object on extends zio.aws.ec2.model.AllowsMultipleInstanceTypes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes =
      software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes.ON
  }
  case object off extends zio.aws.ec2.model.AllowsMultipleInstanceTypes {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes =
      software.amazon.awssdk.services.ec2.model.AllowsMultipleInstanceTypes.OFF
  }
}
