package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{AllocationId, PublicIpAddress}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddressAttribute(
    publicIp: Option[PublicIpAddress] = None,
    allocationId: Option[AllocationId] = None,
    ptrRecord: Option[String] = None,
    ptrRecordUpdate: Option[zio.aws.ec2.model.PtrUpdateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AddressAttribute = {
    import AddressAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AddressAttribute
      .builder()
      .optionallyWith(
        publicIp.map(value => PublicIpAddress.unwrap(value): java.lang.String)
      )(_.publicIp)
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(ptrRecord.map(value => value: java.lang.String))(
        _.ptrRecord
      )
      .optionallyWith(ptrRecordUpdate.map(value => value.buildAwsValue()))(
        _.ptrRecordUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AddressAttribute.ReadOnly =
    zio.aws.ec2.model.AddressAttribute.wrap(buildAwsValue())
}
object AddressAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AddressAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AddressAttribute =
      zio.aws.ec2.model.AddressAttribute(
        publicIp.map(value => value),
        allocationId.map(value => value),
        ptrRecord.map(value => value),
        ptrRecordUpdate.map(value => value.asEditable)
      )
    def publicIp: Option[PublicIpAddress]
    def allocationId: Option[AllocationId]
    def ptrRecord: Option[String]
    def ptrRecordUpdate: Option[zio.aws.ec2.model.PtrUpdateStatus.ReadOnly]
    def getPublicIp: ZIO[Any, AwsError, PublicIpAddress] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getPtrRecord: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ptrRecord", ptrRecord)
    def getPtrRecordUpdate
        : ZIO[Any, AwsError, zio.aws.ec2.model.PtrUpdateStatus.ReadOnly] =
      AwsError.unwrapOptionField("ptrRecordUpdate", ptrRecordUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AddressAttribute
  ) extends zio.aws.ec2.model.AddressAttribute.ReadOnly {
    override val publicIp: Option[PublicIpAddress] = scala
      .Option(impl.publicIp())
      .map(value => zio.aws.ec2.model.primitives.PublicIpAddress(value))
    override val allocationId: Option[AllocationId] = scala
      .Option(impl.allocationId())
      .map(value => zio.aws.ec2.model.primitives.AllocationId(value))
    override val ptrRecord: Option[String] =
      scala.Option(impl.ptrRecord()).map(value => value: String)
    override val ptrRecordUpdate
        : Option[zio.aws.ec2.model.PtrUpdateStatus.ReadOnly] = scala
      .Option(impl.ptrRecordUpdate())
      .map(value => zio.aws.ec2.model.PtrUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AddressAttribute
  ): zio.aws.ec2.model.AddressAttribute.ReadOnly = new Wrapper(impl)
}
