package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpnConnection(
    customerGatewayConfiguration: Option[String] = None,
    customerGatewayId: Option[String] = None,
    category: Option[String] = None,
    state: Option[zio.aws.ec2.model.VpnState] = None,
    `type`: Option[zio.aws.ec2.model.GatewayType] = None,
    vpnConnectionId: Option[String] = None,
    vpnGatewayId: Option[String] = None,
    transitGatewayId: Option[String] = None,
    coreNetworkArn: Option[String] = None,
    coreNetworkAttachmentArn: Option[String] = None,
    gatewayAssociationState: Option[zio.aws.ec2.model.GatewayAssociationState] =
      None,
    options: Option[zio.aws.ec2.model.VpnConnectionOptions] = None,
    routes: Option[Iterable[zio.aws.ec2.model.VpnStaticRoute]] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    vgwTelemetry: Option[Iterable[zio.aws.ec2.model.VgwTelemetry]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpnConnection = {
    import VpnConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnConnection
      .builder()
      .optionallyWith(
        customerGatewayConfiguration.map(value => value: java.lang.String)
      )(_.customerGatewayConfiguration)
      .optionallyWith(customerGatewayId.map(value => value: java.lang.String))(
        _.customerGatewayId
      )
      .optionallyWith(category.map(value => value: java.lang.String))(
        _.category
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(vpnConnectionId.map(value => value: java.lang.String))(
        _.vpnConnectionId
      )
      .optionallyWith(vpnGatewayId.map(value => value: java.lang.String))(
        _.vpnGatewayId
      )
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(coreNetworkArn.map(value => value: java.lang.String))(
        _.coreNetworkArn
      )
      .optionallyWith(
        coreNetworkAttachmentArn.map(value => value: java.lang.String)
      )(_.coreNetworkAttachmentArn)
      .optionallyWith(gatewayAssociationState.map(value => value.unwrap))(
        _.gatewayAssociationState
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        vgwTelemetry.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vgwTelemetry)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnConnection.ReadOnly =
    zio.aws.ec2.model.VpnConnection.wrap(buildAwsValue())
}
object VpnConnection {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpnConnection] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnConnection =
      zio.aws.ec2.model.VpnConnection(
        customerGatewayConfiguration.map(value => value),
        customerGatewayId.map(value => value),
        category.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        vpnConnectionId.map(value => value),
        vpnGatewayId.map(value => value),
        transitGatewayId.map(value => value),
        coreNetworkArn.map(value => value),
        coreNetworkAttachmentArn.map(value => value),
        gatewayAssociationState.map(value => value),
        options.map(value => value.asEditable),
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vgwTelemetry.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerGatewayConfiguration: Option[String]
    def customerGatewayId: Option[String]
    def category: Option[String]
    def state: Option[zio.aws.ec2.model.VpnState]
    def `type`: Option[zio.aws.ec2.model.GatewayType]
    def vpnConnectionId: Option[String]
    def vpnGatewayId: Option[String]
    def transitGatewayId: Option[String]
    def coreNetworkArn: Option[String]
    def coreNetworkAttachmentArn: Option[String]
    def gatewayAssociationState
        : Option[zio.aws.ec2.model.GatewayAssociationState]
    def options: Option[zio.aws.ec2.model.VpnConnectionOptions.ReadOnly]
    def routes: Option[List[zio.aws.ec2.model.VpnStaticRoute.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vgwTelemetry: Option[List[zio.aws.ec2.model.VgwTelemetry.ReadOnly]]
    def getCustomerGatewayConfiguration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "customerGatewayConfiguration",
        customerGatewayConfiguration
      )
    def getCustomerGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getCategory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("category", category)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpnState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.GatewayType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpnConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnConnectionId", vpnConnectionId)
    def getVpnGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCoreNetworkArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getCoreNetworkAttachmentArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("coreNetworkAttachmentArn", coreNetworkAttachmentArn)
    def getGatewayAssociationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.GatewayAssociationState] =
      AwsError.unwrapOptionField(
        "gatewayAssociationState",
        gatewayAssociationState
      )
    def getOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnectionOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getRoutes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpnStaticRoute.ReadOnly]] =
      AwsError.unwrapOptionField("routes", routes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVgwTelemetry
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VgwTelemetry.ReadOnly]] =
      AwsError.unwrapOptionField("vgwTelemetry", vgwTelemetry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnection
  ) extends zio.aws.ec2.model.VpnConnection.ReadOnly {
    override val customerGatewayConfiguration: Option[String] = scala
      .Option(impl.customerGatewayConfiguration())
      .map(value => value: String)
    override val customerGatewayId: Option[String] =
      scala.Option(impl.customerGatewayId()).map(value => value: String)
    override val category: Option[String] =
      scala.Option(impl.category()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.VpnState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.VpnState.wrap(value))
    override val `type`: Option[zio.aws.ec2.model.GatewayType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.GatewayType.wrap(value))
    override val vpnConnectionId: Option[String] =
      scala.Option(impl.vpnConnectionId()).map(value => value: String)
    override val vpnGatewayId: Option[String] =
      scala.Option(impl.vpnGatewayId()).map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val coreNetworkArn: Option[String] =
      scala.Option(impl.coreNetworkArn()).map(value => value: String)
    override val coreNetworkAttachmentArn: Option[String] =
      scala.Option(impl.coreNetworkAttachmentArn()).map(value => value: String)
    override val gatewayAssociationState
        : Option[zio.aws.ec2.model.GatewayAssociationState] = scala
      .Option(impl.gatewayAssociationState())
      .map(value => zio.aws.ec2.model.GatewayAssociationState.wrap(value))
    override val options
        : Option[zio.aws.ec2.model.VpnConnectionOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.ec2.model.VpnConnectionOptions.wrap(value))
    override val routes
        : Option[List[zio.aws.ec2.model.VpnStaticRoute.ReadOnly]] = scala
      .Option(impl.routes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpnStaticRoute.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val vgwTelemetry
        : Option[List[zio.aws.ec2.model.VgwTelemetry.ReadOnly]] = scala
      .Option(impl.vgwTelemetry())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VgwTelemetry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnConnection
  ): zio.aws.ec2.model.VpnConnection.ReadOnly = new Wrapper(impl)
}
