package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ValidationError(
    code: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ValidationError = {
    import ValidationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ValidationError
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ValidationError.ReadOnly =
    zio.aws.ec2.model.ValidationError.wrap(buildAwsValue())
}
object ValidationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ValidationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ValidationError = zio.aws.ec2.model
      .ValidationError(code.map(value => value), message.map(value => value))
    def code: Option[String]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ValidationError
  ) extends zio.aws.ec2.model.ValidationError.ReadOnly {
    override val code: Option[String] =
      scala.Option(impl.code()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ValidationError
  ): zio.aws.ec2.model.ValidationError.ReadOnly = new Wrapper(impl)
}
