package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserData(data: Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.UserData = {
    import UserData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UserData
      .builder()
      .optionallyWith(data.map(value => value: java.lang.String))(_.data)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UserData.ReadOnly =
    zio.aws.ec2.model.UserData.wrap(buildAwsValue())
}
object UserData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.UserData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UserData =
      zio.aws.ec2.model.UserData(data.map(value => value))
    def data: Option[String]
    def getData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UserData
  ) extends zio.aws.ec2.model.UserData.ReadOnly {
    override val data: Option[String] =
      scala.Option(impl.data()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UserData
  ): zio.aws.ec2.model.UserData.ReadOnly = new Wrapper(impl)
}
