package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnassignIpv6AddressesResponse(
    networkInterfaceId: Option[String] = None,
    unassignedIpv6Addresses: Option[Iterable[String]] = None,
    unassignedIpv6Prefixes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse = {
    import UnassignIpv6AddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse
      .builder()
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(
        unassignedIpv6Addresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.unassignedIpv6Addresses)
      .optionallyWith(
        unassignedIpv6Prefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.unassignedIpv6Prefixes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly =
    zio.aws.ec2.model.UnassignIpv6AddressesResponse.wrap(buildAwsValue())
}
object UnassignIpv6AddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UnassignIpv6AddressesResponse =
      zio.aws.ec2.model.UnassignIpv6AddressesResponse(
        networkInterfaceId.map(value => value),
        unassignedIpv6Addresses.map(value => value),
        unassignedIpv6Prefixes.map(value => value)
      )
    def networkInterfaceId: Option[String]
    def unassignedIpv6Addresses: Option[List[String]]
    def unassignedIpv6Prefixes: Option[List[String]]
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getUnassignedIpv6Addresses: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("unassignedIpv6Addresses", unassignedIpv6Addresses)
    def getUnassignedIpv6Prefixes: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("unassignedIpv6Prefixes", unassignedIpv6Prefixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse
  ) extends zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly {
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val unassignedIpv6Addresses: Option[List[String]] = scala
      .Option(impl.unassignedIpv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val unassignedIpv6Prefixes: Option[List[String]] = scala
      .Option(impl.unassignedIpv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse
  ): zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly = new Wrapper(
    impl
  )
}
