package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayState {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransitGatewayState
}
object TransitGatewayState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayState
  ): zio.aws.ec2.model.TransitGatewayState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayState.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.TransitGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayState.PENDING
  }
  case object available extends zio.aws.ec2.model.TransitGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayState.AVAILABLE
  }
  case object modifying extends zio.aws.ec2.model.TransitGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayState.MODIFYING
  }
  case object deleting extends zio.aws.ec2.model.TransitGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.TransitGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayState.DELETED
  }
}
