package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrafficMirrorSession(
    trafficMirrorSessionId: Option[String] = None,
    trafficMirrorTargetId: Option[String] = None,
    trafficMirrorFilterId: Option[String] = None,
    networkInterfaceId: Option[String] = None,
    ownerId: Option[String] = None,
    packetLength: Option[Integer] = None,
    sessionNumber: Option[Integer] = None,
    virtualNetworkId: Option[Integer] = None,
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorSession = {
    import TrafficMirrorSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
      .builder()
      .optionallyWith(
        trafficMirrorSessionId.map(value => value: java.lang.String)
      )(_.trafficMirrorSessionId)
      .optionallyWith(
        trafficMirrorTargetId.map(value => value: java.lang.String)
      )(_.trafficMirrorTargetId)
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        packetLength.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.packetLength)
      .optionallyWith(
        sessionNumber.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sessionNumber)
      .optionallyWith(
        virtualNetworkId.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.virtualNetworkId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorSession.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorSession.wrap(buildAwsValue())
}
object TrafficMirrorSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorSession =
      zio.aws.ec2.model.TrafficMirrorSession(
        trafficMirrorSessionId.map(value => value),
        trafficMirrorTargetId.map(value => value),
        trafficMirrorFilterId.map(value => value),
        networkInterfaceId.map(value => value),
        ownerId.map(value => value),
        packetLength.map(value => value),
        sessionNumber.map(value => value),
        virtualNetworkId.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficMirrorSessionId: Option[String]
    def trafficMirrorTargetId: Option[String]
    def trafficMirrorFilterId: Option[String]
    def networkInterfaceId: Option[String]
    def ownerId: Option[String]
    def packetLength: Option[Integer]
    def sessionNumber: Option[Integer]
    def virtualNetworkId: Option[Integer]
    def description: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTrafficMirrorSessionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorSessionId", trafficMirrorSessionId)
    def getTrafficMirrorTargetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorTargetId", trafficMirrorTargetId)
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPacketLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("packetLength", packetLength)
    def getSessionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sessionNumber", sessionNumber)
    def getVirtualNetworkId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("virtualNetworkId", virtualNetworkId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
  ) extends zio.aws.ec2.model.TrafficMirrorSession.ReadOnly {
    override val trafficMirrorSessionId: Option[String] =
      scala.Option(impl.trafficMirrorSessionId()).map(value => value: String)
    override val trafficMirrorTargetId: Option[String] =
      scala.Option(impl.trafficMirrorTargetId()).map(value => value: String)
    override val trafficMirrorFilterId: Option[String] =
      scala.Option(impl.trafficMirrorFilterId()).map(value => value: String)
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val packetLength: Option[Integer] = scala
      .Option(impl.packetLength())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val sessionNumber: Option[Integer] = scala
      .Option(impl.sessionNumber())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val virtualNetworkId: Option[Integer] = scala
      .Option(impl.virtualNetworkId())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
  ): zio.aws.ec2.model.TrafficMirrorSession.ReadOnly = new Wrapper(impl)
}
