package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficMirrorNetworkService {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService
}
object TrafficMirrorNetworkService {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService
  ): zio.aws.ec2.model.TrafficMirrorNetworkService = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService.AMAZON_DNS =>
      val r = `amazon-dns`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TrafficMirrorNetworkService {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService.UNKNOWN_TO_SDK_VERSION
  }
  case object `amazon-dns`
      extends zio.aws.ec2.model.TrafficMirrorNetworkService {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService =
      software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService.AMAZON_DNS
  }
}
