package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StorageLocation(
    bucket: Option[String] = None,
    key: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StorageLocation = {
    import StorageLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StorageLocation
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StorageLocation.ReadOnly =
    zio.aws.ec2.model.StorageLocation.wrap(buildAwsValue())
}
object StorageLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StorageLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StorageLocation = zio.aws.ec2.model
      .StorageLocation(bucket.map(value => value), key.map(value => value))
    def bucket: Option[String]
    def key: Option[String]
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StorageLocation
  ) extends zio.aws.ec2.model.StorageLocation.ReadOnly {
    override val bucket: Option[String] =
      scala.Option(impl.bucket()).map(value => value: String)
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StorageLocation
  ): zio.aws.ec2.model.StorageLocation.ReadOnly = new Wrapper(impl)
}
