package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotCapacityRebalance(
    replacementStrategy: Option[zio.aws.ec2.model.ReplacementStrategy] = None,
    terminationDelay: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance = {
    import SpotCapacityRebalance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
      .builder()
      .optionallyWith(replacementStrategy.map(value => value.unwrap))(
        _.replacementStrategy
      )
      .optionallyWith(
        terminationDelay.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.terminationDelay)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly =
    zio.aws.ec2.model.SpotCapacityRebalance.wrap(buildAwsValue())
}
object SpotCapacityRebalance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotCapacityRebalance =
      zio.aws.ec2.model.SpotCapacityRebalance(
        replacementStrategy.map(value => value),
        terminationDelay.map(value => value)
      )
    def replacementStrategy: Option[zio.aws.ec2.model.ReplacementStrategy]
    def terminationDelay: Option[Integer]
    def getReplacementStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReplacementStrategy] =
      AwsError.unwrapOptionField("replacementStrategy", replacementStrategy)
    def getTerminationDelay: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("terminationDelay", terminationDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
  ) extends zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly {
    override val replacementStrategy
        : Option[zio.aws.ec2.model.ReplacementStrategy] = scala
      .Option(impl.replacementStrategy())
      .map(value => zio.aws.ec2.model.ReplacementStrategy.wrap(value))
    override val terminationDelay: Option[Integer] = scala
      .Option(impl.terminationDelay())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotCapacityRebalance
  ): zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly = new Wrapper(impl)
}
