package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SnapshotRecycleBinInfo(
    snapshotId: Option[String] = None,
    recycleBinEnterTime: Option[MillisecondDateTime] = None,
    recycleBinExitTime: Option[MillisecondDateTime] = None,
    description: Option[String] = None,
    volumeId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo = {
    import SnapshotRecycleBinInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        recycleBinEnterTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinEnterTime)
      .optionallyWith(
        recycleBinExitTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinExitTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly =
    zio.aws.ec2.model.SnapshotRecycleBinInfo.wrap(buildAwsValue())
}
object SnapshotRecycleBinInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotRecycleBinInfo =
      zio.aws.ec2.model.SnapshotRecycleBinInfo(
        snapshotId.map(value => value),
        recycleBinEnterTime.map(value => value),
        recycleBinExitTime.map(value => value),
        description.map(value => value),
        volumeId.map(value => value)
      )
    def snapshotId: Option[String]
    def recycleBinEnterTime: Option[MillisecondDateTime]
    def recycleBinExitTime: Option[MillisecondDateTime]
    def description: Option[String]
    def volumeId: Option[String]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getRecycleBinEnterTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinEnterTime", recycleBinEnterTime)
    def getRecycleBinExitTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinExitTime", recycleBinExitTime)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
  ) extends zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly {
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val recycleBinEnterTime: Option[MillisecondDateTime] = scala
      .Option(impl.recycleBinEnterTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val recycleBinExitTime: Option[MillisecondDateTime] = scala
      .Option(impl.recycleBinExitTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
  ): zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly = new Wrapper(impl)
}
