package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{CoreNetworkArn, CarrierGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Route(
    destinationCidrBlock: Option[String] = None,
    destinationIpv6CidrBlock: Option[String] = None,
    destinationPrefixListId: Option[String] = None,
    egressOnlyInternetGatewayId: Option[String] = None,
    gatewayId: Option[String] = None,
    instanceId: Option[String] = None,
    instanceOwnerId: Option[String] = None,
    natGatewayId: Option[String] = None,
    transitGatewayId: Option[String] = None,
    localGatewayId: Option[String] = None,
    carrierGatewayId: Option[CarrierGatewayId] = None,
    networkInterfaceId: Option[String] = None,
    origin: Option[zio.aws.ec2.model.RouteOrigin] = None,
    state: Option[zio.aws.ec2.model.RouteState] = None,
    vpcPeeringConnectionId: Option[String] = None,
    coreNetworkArn: Option[CoreNetworkArn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Route = {
    import Route.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Route
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value => value: java.lang.String)
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value => value: java.lang.String)
      )(_.destinationPrefixListId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value => value: java.lang.String)
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceOwnerId.map(value => value: java.lang.String))(
        _.instanceOwnerId
      )
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(localGatewayId.map(value => value: java.lang.String))(
        _.localGatewayId
      )
      .optionallyWith(
        carrierGatewayId.map(value =>
          CarrierGatewayId.unwrap(value): java.lang.String
        )
      )(_.carrierGatewayId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Route.ReadOnly =
    zio.aws.ec2.model.Route.wrap(buildAwsValue())
}
object Route {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Route] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Route = zio.aws.ec2.model.Route(
      destinationCidrBlock.map(value => value),
      destinationIpv6CidrBlock.map(value => value),
      destinationPrefixListId.map(value => value),
      egressOnlyInternetGatewayId.map(value => value),
      gatewayId.map(value => value),
      instanceId.map(value => value),
      instanceOwnerId.map(value => value),
      natGatewayId.map(value => value),
      transitGatewayId.map(value => value),
      localGatewayId.map(value => value),
      carrierGatewayId.map(value => value),
      networkInterfaceId.map(value => value),
      origin.map(value => value),
      state.map(value => value),
      vpcPeeringConnectionId.map(value => value),
      coreNetworkArn.map(value => value)
    )
    def destinationCidrBlock: Option[String]
    def destinationIpv6CidrBlock: Option[String]
    def destinationPrefixListId: Option[String]
    def egressOnlyInternetGatewayId: Option[String]
    def gatewayId: Option[String]
    def instanceId: Option[String]
    def instanceOwnerId: Option[String]
    def natGatewayId: Option[String]
    def transitGatewayId: Option[String]
    def localGatewayId: Option[String]
    def carrierGatewayId: Option[CarrierGatewayId]
    def networkInterfaceId: Option[String]
    def origin: Option[zio.aws.ec2.model.RouteOrigin]
    def state: Option[zio.aws.ec2.model.RouteState]
    def vpcPeeringConnectionId: Option[String]
    def coreNetworkArn: Option[CoreNetworkArn]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationPrefixListId", destinationPrefixListId)
    def getEgressOnlyInternetGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceOwnerId", instanceOwnerId)
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getLocalGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getCarrierGatewayId: ZIO[Any, AwsError, CarrierGatewayId] =
      AwsError.unwrapOptionField("carrierGatewayId", carrierGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOrigin: ZIO[Any, AwsError, zio.aws.ec2.model.RouteOrigin] =
      AwsError.unwrapOptionField("origin", origin)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.RouteState] =
      AwsError.unwrapOptionField("state", state)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Route
  ) extends zio.aws.ec2.model.Route.ReadOnly {
    override val destinationCidrBlock: Option[String] =
      scala.Option(impl.destinationCidrBlock()).map(value => value: String)
    override val destinationIpv6CidrBlock: Option[String] =
      scala.Option(impl.destinationIpv6CidrBlock()).map(value => value: String)
    override val destinationPrefixListId: Option[String] =
      scala.Option(impl.destinationPrefixListId()).map(value => value: String)
    override val egressOnlyInternetGatewayId: Option[String] = scala
      .Option(impl.egressOnlyInternetGatewayId())
      .map(value => value: String)
    override val gatewayId: Option[String] =
      scala.Option(impl.gatewayId()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val instanceOwnerId: Option[String] =
      scala.Option(impl.instanceOwnerId()).map(value => value: String)
    override val natGatewayId: Option[String] =
      scala.Option(impl.natGatewayId()).map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val localGatewayId: Option[String] =
      scala.Option(impl.localGatewayId()).map(value => value: String)
    override val carrierGatewayId: Option[CarrierGatewayId] = scala
      .Option(impl.carrierGatewayId())
      .map(value => zio.aws.ec2.model.primitives.CarrierGatewayId(value))
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val origin: Option[zio.aws.ec2.model.RouteOrigin] = scala
      .Option(impl.origin())
      .map(value => zio.aws.ec2.model.RouteOrigin.wrap(value))
    override val state: Option[zio.aws.ec2.model.RouteState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.RouteState.wrap(value))
    override val vpcPeeringConnectionId: Option[String] =
      scala.Option(impl.vpcPeeringConnectionId()).map(value => value: String)
    override val coreNetworkArn: Option[CoreNetworkArn] = scala
      .Option(impl.coreNetworkArn())
      .map(value => zio.aws.ec2.model.primitives.CoreNetworkArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Route
  ): zio.aws.ec2.model.Route.ReadOnly = new Wrapper(impl)
}
